﻿-- Creating table 'GF_Achievement'
CREATE TABLE [dbo].[GF_Achievement] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Title] nvarchar(max)  NOT NULL,
    [Picture] nvarchar(max)  NOT NULL,
    [Description] nvarchar(max)  NOT NULL
);
GO

-- Creating table 'GF_AssignedAchievement'
CREATE TABLE [dbo].[GF_AssignedAchievement] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Principal_PrincipalID] int  NOT NULL
);
GO

-- Creating table 'GF_Accolade'
CREATE TABLE [dbo].[GF_Accolade] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Date] datetime  NOT NULL,
    [Text] nvarchar(max)  NOT NULL,
    [GF_AssignedAchievement_Id] int  NOT NULL,
    [Principal_PrincipalID] int  NOT NULL
);
GO

-- Creating table 'GF_AssignedCertificate'
CREATE TABLE [dbo].[GF_AssignedCertificate] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [ExpireDate] datetime  NULL,
    [Type] nvarchar(max)  NULL,
    [TypeId] int  NULL,
    [Metadata] nvarchar(max)  NULL,
    [GF_Certificate_Id] int  NOT NULL,
    [GF_AssignedAchievement_Id] int  NOT NULL
);
GO

-- Creating table 'GF_AssignedBadge'
CREATE TABLE [dbo].[GF_AssignedBadge] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [ExpireDate] datetime  NULL,
    [Type] nvarchar(max)  NULL,
    [TypeId] int  NULL,
    [Metadata] nvarchar(max)  NULL,
    [GF_Badge_Id] int  NOT NULL,
    [GF_AssignedAchievement_Id] int  NOT NULL
);
GO

-- Creating table 'GF_AssignedSkill'
CREATE TABLE [dbo].[GF_AssignedSkill] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [DowngradeDate] datetime  NULL,
    [CurrentProcent] float  NOT NULL,
    [Type] nvarchar(max)  NULL,
    [TypeId] int  NULL,
    [Metadata] nvarchar(max)  NULL,
    [GF_Skills_Id] int  NOT NULL,
    [GF_AssignedAchievement_Id] int  NOT NULL,
    [GF_SkillLevel_Id] int  NOT NULL
);
GO

-- Creating table 'GF_SkillLevel'
CREATE TABLE [dbo].[GF_SkillLevel] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Name] nvarchar(max)  NOT NULL,
    [RequiredProcent] int  NOT NULL,
    [GF_Skills_Id] int  NOT NULL
);
GO

-- Creating table 'GF_Quiz'
CREATE TABLE [dbo].[GF_Quiz] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Title] nvarchar(max)  NOT NULL,
    [EndDate] datetime  NOT NULL,
    [CanEdit] bit  NOT NULL,
    [QuizType] int  NOT NULL,
    [Logo] nvarchar(max)  NULL,
    [WinnerAvaliable] bit  NOT NULL,
    [MaxPoint] int  NULL,
    [Description] nvarchar(max)  NULL,
    [UseSocial] bit  NULL,
    [ShowOverview] bit  NULL,
    [StartDate] datetime  NULL,
    [Ended] bit  NULL
);
GO

-- Creating table 'GF_Field'
CREATE TABLE [dbo].[GF_Field] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Title] nvarchar(max)  NOT NULL,
    [Type] nvarchar(max)  NOT NULL,
    [Value] nvarchar(max)  NOT NULL,
    [Required] bit  NOT NULL,
    [CorrectOption] int  NOT NULL,
    [Point] int  NOT NULL,
    [GF_Quiz_Id] int  NOT NULL
);
GO

-- Creating table 'GF_Option'
CREATE TABLE [dbo].[GF_Option] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Title] nvarchar(max)  NOT NULL,
    [Value] int  NOT NULL,
    [GF_Field_Id] int  NOT NULL
);
GO

-- Creating table 'GF_Response'
CREATE TABLE [dbo].[GF_Response] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Score] int  NOT NULL,
    [AllCorrect] bit  NOT NULL,
    [Principal_PrincipalID] int  NOT NULL,
    [GF_Field_Id] int  NOT NULL
);
GO

-- Creating table 'GF_ResponseField'
CREATE TABLE [dbo].[GF_ResponseField] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Value] nvarchar(max)  NOT NULL,
    [FieldId] int  NOT NULL,
    [GF_Response_Id] int  NOT NULL
);
GO

-- Creating table 'GF_QuizMembers'
CREATE TABLE [dbo].[GF_QuizMembers] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Type] nvarchar(max)  NOT NULL,
    [UniqueId] nvarchar(max)  NOT NULL,
    [Title] nvarchar(max)  NOT NULL,
    [GF_Quiz_Id] int  NOT NULL
);
GO

-- Creating table 'GF_QuizAdmin'
CREATE TABLE [dbo].[GF_QuizAdmin] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Type] nvarchar(max)  NOT NULL,
    [UniqueId] nvarchar(max)  NOT NULL,
    [Title] nvarchar(max)  NOT NULL,
    [GF_Quiz_Id] int  NOT NULL
);
GO

-- Creating table 'GF_Tournament'
CREATE TABLE [dbo].[GF_Tournament] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Title] nvarchar(max)  NOT NULL,
    [Amount] float  NOT NULL,
    [EndDate] datetime  NOT NULL,
    [Logo] nvarchar(max)  NULL,
    [Description] nvarchar(max)  NULL,
    [Ended] bit  NULL,
    [StartDate] datetime  NULL
);
GO

-- Creating table 'GF_TournamentAdmin'
CREATE TABLE [dbo].[GF_TournamentAdmin] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Type] nvarchar(max)  NOT NULL,
    [UniqueId] nvarchar(max)  NOT NULL,
    [Title] nvarchar(max)  NOT NULL,
    [GF_Tournament_Id] int  NOT NULL
);
GO

-- Creating table 'GF_TournamentMember'
CREATE TABLE [dbo].[GF_TournamentMember] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Type] nvarchar(max)  NOT NULL,
    [UniqueId] nvarchar(max)  NOT NULL,
    [Title] nvarchar(max)  NOT NULL,
    [GF_Tournament_Id] int  NOT NULL
);
GO

-- Creating table 'GF_SpecialBet'
CREATE TABLE [dbo].[GF_SpecialBet] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Title] nvarchar(max)  NOT NULL,
    [StartDate] datetime  NOT NULL,
    [CorrectAnswer] int  NOT NULL,
    [Finished] bit  NOT NULL,
    [GF_Tournament_Id] int  NOT NULL
);
GO

-- Creating table 'GF_SpecialbetOption'
CREATE TABLE [dbo].[GF_SpecialbetOption] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Title] nvarchar(max)  NOT NULL,
    [Odds] float  NOT NULL,
    [GF_SpecialBet_Id] int  NOT NULL
);
GO

-- Creating table 'GF_Game'
CREATE TABLE [dbo].[GF_Game] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Finished] bit  NOT NULL,
    [TeamOneGuid] uniqueidentifier  NOT NULL,
    [TeamTwoGuid] uniqueidentifier  NOT NULL,
    [GoalsTeamOne] int  NOT NULL,
    [GoalsTeamTwo] int  NOT NULL,
    [Winner] int  NOT NULL,
    [OddsTeamOne] float  NOT NULL,
    [OddsDraw] float  NOT NULL,
    [OddsTeamTwo] float  NOT NULL,
    [StartDate] datetime  NOT NULL,
    [ProviderGameId] int  NULL,
    [GF_Tournament_Id] int  NOT NULL
);
GO

-- Creating table 'GF_ExternalTeam'
CREATE TABLE [dbo].[GF_ExternalTeam] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Title] nvarchar(max)  NOT NULL,
    [Flag] nvarchar(max)  NOT NULL,
    [Guid] uniqueidentifier  NOT NULL,
    [ProviderTitle] nvarchar(max)  NOT NULL,
    [GF_ExternalTournament_Id] int  NOT NULL
);
GO

-- Creating table 'GF_Placedbet'
CREATE TABLE [dbo].[GF_Placedbet] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Loginname] nvarchar(max)  NOT NULL,
    [GF_Tournament_Id] int  NOT NULL
);
GO

-- Creating table 'GF_PlacedGameBet'
CREATE TABLE [dbo].[GF_PlacedGameBet] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Calculated] bit  NOT NULL,
    [Winner] int  NOT NULL,
    [Amount] float  NOT NULL,
    [Odds] float  NOT NULL,
    [GameId] int  NOT NULL,
    [GF_Placedbet_Id] int  NOT NULL
);
GO

-- Creating table 'GF_PlacedSpecialbet'
CREATE TABLE [dbo].[GF_PlacedSpecialbet] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Calculated] bit  NOT NULL,
    [Winner] int  NOT NULL,
    [Amount] float  NOT NULL,
    [Odds] float  NOT NULL,
    [CustomBetId] int  NOT NULL,
    [GF_Placedbet_Id] int  NOT NULL
);
GO

-- Creating table 'GF_TournamentUser'
CREATE TABLE [dbo].[GF_TournamentUser] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [UserId] nvarchar(max)  NOT NULL,
    [Balance] float  NOT NULL,
    [AvgWins] float  NOT NULL,
    [AvgBets] float  NOT NULL,
    [AvgOdds] float  NOT NULL,
    [GF_Tournament_Id] int  NOT NULL,
    [NB_Channel_ChannelID] int  NOT NULL
);
GO

-- Creating table 'GF_InteralTeam'
CREATE TABLE [dbo].[GF_InteralTeam] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Title] nvarchar(max)  NOT NULL,
    [Logo] nvarchar(max)  NULL,
    [Guid] nvarchar(max)  NOT NULL,
    [GF_InternalTournament_Id] int  NOT NULL
);
GO

-- Creating table 'GF_QuizAction'
CREATE TABLE [dbo].[GF_QuizAction] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Action] nvarchar(max)  NOT NULL,
    [GF_Quiz_Id] int  NOT NULL,
    [GF_Achievement_Id] int  NOT NULL
);
GO

-- Creating table 'GF_TournamentAction'
CREATE TABLE [dbo].[GF_TournamentAction] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Action] nvarchar(max)  NOT NULL,
    [GF_Tournament_Id] int  NOT NULL,
    [GF_Achievement_Id] int  NOT NULL
);
GO

-- Creating table 'GF_Achievement_GF_Skills'
CREATE TABLE [dbo].[GF_Achievement_GF_Skills] (
    [IsDegraded] bit  NOT NULL,
    [Points] int  NULL,
    [Period] nvarchar(max)  NULL,
    [Id] int  NOT NULL
);
GO

-- Creating table 'GF_Achievement_GF_Badge'
CREATE TABLE [dbo].[GF_Achievement_GF_Badge] (
    [Expires] bit  NOT NULL,
    [Period] nvarchar(max)  NULL,
    [Number] int  NULL,
    [Id] int  NOT NULL
);
GO

-- Creating table 'GF_Achievement_GF_Certificate'
CREATE TABLE [dbo].[GF_Achievement_GF_Certificate] (
    [Expires] bit  NOT NULL,
    [Period] nvarchar(max)  NULL,
    [Number] int  NULL,
    [Id] int  NOT NULL
);
GO

-- Creating table 'GF_Tournament_GF_ExternalTournament'
CREATE TABLE [dbo].[GF_Tournament_GF_ExternalTournament] (
    [ProviderLeague] int  NULL,
    [ProviderSport] int  NULL,
    [ProviderLastTimestamp] bigint  NULL,
    [Id] int  NOT NULL
);
GO

-- Creating table 'GF_Tournament_GF_InternalTournament'
CREATE TABLE [dbo].[GF_Tournament_GF_InternalTournament] (
    [Id] int  NOT NULL
);
GO



-- Creating primary key on [Id] in table 'GF_Achievement'
ALTER TABLE [dbo].[GF_Achievement]
ADD CONSTRAINT [PK_GF_Achievement]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GF_AssignedAchievement'
ALTER TABLE [dbo].[GF_AssignedAchievement]
ADD CONSTRAINT [PK_GF_AssignedAchievement]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GF_Accolade'
ALTER TABLE [dbo].[GF_Accolade]
ADD CONSTRAINT [PK_GF_Accolade]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GF_AssignedCertificate'
ALTER TABLE [dbo].[GF_AssignedCertificate]
ADD CONSTRAINT [PK_GF_AssignedCertificate]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GF_AssignedBadge'
ALTER TABLE [dbo].[GF_AssignedBadge]
ADD CONSTRAINT [PK_GF_AssignedBadge]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GF_AssignedSkill'
ALTER TABLE [dbo].[GF_AssignedSkill]
ADD CONSTRAINT [PK_GF_AssignedSkill]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GF_SkillLevel'
ALTER TABLE [dbo].[GF_SkillLevel]
ADD CONSTRAINT [PK_GF_SkillLevel]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GF_Quiz'
ALTER TABLE [dbo].[GF_Quiz]
ADD CONSTRAINT [PK_GF_Quiz]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GF_Field'
ALTER TABLE [dbo].[GF_Field]
ADD CONSTRAINT [PK_GF_Field]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GF_Option'
ALTER TABLE [dbo].[GF_Option]
ADD CONSTRAINT [PK_GF_Option]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GF_Response'
ALTER TABLE [dbo].[GF_Response]
ADD CONSTRAINT [PK_GF_Response]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GF_ResponseField'
ALTER TABLE [dbo].[GF_ResponseField]
ADD CONSTRAINT [PK_GF_ResponseField]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GF_QuizMembers'
ALTER TABLE [dbo].[GF_QuizMembers]
ADD CONSTRAINT [PK_GF_QuizMembers]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GF_QuizAdmin'
ALTER TABLE [dbo].[GF_QuizAdmin]
ADD CONSTRAINT [PK_GF_QuizAdmin]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GF_Tournament'
ALTER TABLE [dbo].[GF_Tournament]
ADD CONSTRAINT [PK_GF_Tournament]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GF_TournamentAdmin'
ALTER TABLE [dbo].[GF_TournamentAdmin]
ADD CONSTRAINT [PK_GF_TournamentAdmin]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GF_TournamentMember'
ALTER TABLE [dbo].[GF_TournamentMember]
ADD CONSTRAINT [PK_GF_TournamentMember]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GF_SpecialBet'
ALTER TABLE [dbo].[GF_SpecialBet]
ADD CONSTRAINT [PK_GF_SpecialBet]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GF_SpecialbetOption'
ALTER TABLE [dbo].[GF_SpecialbetOption]
ADD CONSTRAINT [PK_GF_SpecialbetOption]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GF_Game'
ALTER TABLE [dbo].[GF_Game]
ADD CONSTRAINT [PK_GF_Game]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GF_ExternalTeam'
ALTER TABLE [dbo].[GF_ExternalTeam]
ADD CONSTRAINT [PK_GF_ExternalTeam]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GF_Placedbet'
ALTER TABLE [dbo].[GF_Placedbet]
ADD CONSTRAINT [PK_GF_Placedbet]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GF_PlacedGameBet'
ALTER TABLE [dbo].[GF_PlacedGameBet]
ADD CONSTRAINT [PK_GF_PlacedGameBet]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GF_PlacedSpecialbet'
ALTER TABLE [dbo].[GF_PlacedSpecialbet]
ADD CONSTRAINT [PK_GF_PlacedSpecialbet]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GF_TournamentUser'
ALTER TABLE [dbo].[GF_TournamentUser]
ADD CONSTRAINT [PK_GF_TournamentUser]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GF_InteralTeam'
ALTER TABLE [dbo].[GF_InteralTeam]
ADD CONSTRAINT [PK_GF_InteralTeam]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GF_QuizAction'
ALTER TABLE [dbo].[GF_QuizAction]
ADD CONSTRAINT [PK_GF_QuizAction]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GF_TournamentAction'
ALTER TABLE [dbo].[GF_TournamentAction]
ADD CONSTRAINT [PK_GF_TournamentAction]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GF_Achievement_GF_Skills'
ALTER TABLE [dbo].[GF_Achievement_GF_Skills]
ADD CONSTRAINT [PK_GF_Achievement_GF_Skills]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GF_Achievement_GF_Badge'
ALTER TABLE [dbo].[GF_Achievement_GF_Badge]
ADD CONSTRAINT [PK_GF_Achievement_GF_Badge]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GF_Achievement_GF_Certificate'
ALTER TABLE [dbo].[GF_Achievement_GF_Certificate]
ADD CONSTRAINT [PK_GF_Achievement_GF_Certificate]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GF_Tournament_GF_ExternalTournament'
ALTER TABLE [dbo].[GF_Tournament_GF_ExternalTournament]
ADD CONSTRAINT [PK_GF_Tournament_GF_ExternalTournament]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GF_Tournament_GF_InternalTournament'
ALTER TABLE [dbo].[GF_Tournament_GF_InternalTournament]
ADD CONSTRAINT [PK_GF_Tournament_GF_InternalTournament]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO


-- Creating foreign key on [GF_Skills_Id] in table 'GF_SkillLevel'
ALTER TABLE [dbo].[GF_SkillLevel]
ADD CONSTRAINT [FK_GF_SkillsSkillLevel]
    FOREIGN KEY ([GF_Skills_Id])
    REFERENCES [dbo].[GF_Achievement_GF_Skills]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GF_SkillsSkillLevel'
CREATE INDEX [IX_FK_GF_SkillsSkillLevel]
ON [dbo].[GF_SkillLevel]
    ([GF_Skills_Id]);
GO

-- Creating foreign key on [GF_Skills_Id] in table 'GF_AssignedSkill'
ALTER TABLE [dbo].[GF_AssignedSkill]
ADD CONSTRAINT [FK_GF_SkillsGF_AssignedSkill]
    FOREIGN KEY ([GF_Skills_Id])
    REFERENCES [dbo].[GF_Achievement_GF_Skills]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GF_SkillsGF_AssignedSkill'
CREATE INDEX [IX_FK_GF_SkillsGF_AssignedSkill]
ON [dbo].[GF_AssignedSkill]
    ([GF_Skills_Id]);
GO

-- Creating foreign key on [GF_Badge_Id] in table 'GF_AssignedBadge'
ALTER TABLE [dbo].[GF_AssignedBadge]
ADD CONSTRAINT [FK_GF_BadgeGF_AssignedBadge]
    FOREIGN KEY ([GF_Badge_Id])
    REFERENCES [dbo].[GF_Achievement_GF_Badge]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GF_BadgeGF_AssignedBadge'
CREATE INDEX [IX_FK_GF_BadgeGF_AssignedBadge]
ON [dbo].[GF_AssignedBadge]
    ([GF_Badge_Id]);
GO

-- Creating foreign key on [GF_Certificate_Id] in table 'GF_AssignedCertificate'
ALTER TABLE [dbo].[GF_AssignedCertificate]
ADD CONSTRAINT [FK_GF_CertificateGF_AssignedCertificate]
    FOREIGN KEY ([GF_Certificate_Id])
    REFERENCES [dbo].[GF_Achievement_GF_Certificate]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GF_CertificateGF_AssignedCertificate'
CREATE INDEX [IX_FK_GF_CertificateGF_AssignedCertificate]
ON [dbo].[GF_AssignedCertificate]
    ([GF_Certificate_Id]);
GO

-- Creating foreign key on [GF_AssignedAchievement_Id] in table 'GF_AssignedSkill'
ALTER TABLE [dbo].[GF_AssignedSkill]
ADD CONSTRAINT [FK_GF_AssignedAchievementGF_AssignedSkill]
    FOREIGN KEY ([GF_AssignedAchievement_Id])
    REFERENCES [dbo].[GF_AssignedAchievement]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GF_AssignedAchievementGF_AssignedSkill'
CREATE INDEX [IX_FK_GF_AssignedAchievementGF_AssignedSkill]
ON [dbo].[GF_AssignedSkill]
    ([GF_AssignedAchievement_Id]);
GO

-- Creating foreign key on [GF_AssignedAchievement_Id] in table 'GF_AssignedCertificate'
ALTER TABLE [dbo].[GF_AssignedCertificate]
ADD CONSTRAINT [FK_GF_AssignedAchievementGF_AssignedCertificate]
    FOREIGN KEY ([GF_AssignedAchievement_Id])
    REFERENCES [dbo].[GF_AssignedAchievement]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GF_AssignedAchievementGF_AssignedCertificate'
CREATE INDEX [IX_FK_GF_AssignedAchievementGF_AssignedCertificate]
ON [dbo].[GF_AssignedCertificate]
    ([GF_AssignedAchievement_Id]);
GO

-- Creating foreign key on [GF_AssignedAchievement_Id] in table 'GF_AssignedBadge'
ALTER TABLE [dbo].[GF_AssignedBadge]
ADD CONSTRAINT [FK_GF_AssignedAchievementGF_AssignedBadge]
    FOREIGN KEY ([GF_AssignedAchievement_Id])
    REFERENCES [dbo].[GF_AssignedAchievement]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GF_AssignedAchievementGF_AssignedBadge'
CREATE INDEX [IX_FK_GF_AssignedAchievementGF_AssignedBadge]
ON [dbo].[GF_AssignedBadge]
    ([GF_AssignedAchievement_Id]);
GO

-- Creating foreign key on [GF_AssignedAchievement_Id] in table 'GF_Accolade'
ALTER TABLE [dbo].[GF_Accolade]
ADD CONSTRAINT [FK_GF_AssignedAchievementGF_Accolade]
    FOREIGN KEY ([GF_AssignedAchievement_Id])
    REFERENCES [dbo].[GF_AssignedAchievement]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GF_AssignedAchievementGF_Accolade'
CREATE INDEX [IX_FK_GF_AssignedAchievementGF_Accolade]
ON [dbo].[GF_Accolade]
    ([GF_AssignedAchievement_Id]);
GO

-- Creating foreign key on [Principal_PrincipalID] in table 'GF_Accolade'
ALTER TABLE [dbo].[GF_Accolade]
ADD CONSTRAINT [FK_PrincipalGF_Accolade]
    FOREIGN KEY ([Principal_PrincipalID])
    REFERENCES [dbo].[Principal]
        ([PrincipalID])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_PrincipalGF_Accolade'
CREATE INDEX [IX_FK_PrincipalGF_Accolade]
ON [dbo].[GF_Accolade]
    ([Principal_PrincipalID]);
GO

-- Creating foreign key on [Principal_PrincipalID] in table 'GF_AssignedAchievement'
ALTER TABLE [dbo].[GF_AssignedAchievement]
ADD CONSTRAINT [FK_PrincipalGF_AssignedAchievement]
    FOREIGN KEY ([Principal_PrincipalID])
    REFERENCES [dbo].[Principal]
        ([PrincipalID])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_PrincipalGF_AssignedAchievement'
CREATE INDEX [IX_FK_PrincipalGF_AssignedAchievement]
ON [dbo].[GF_AssignedAchievement]
    ([Principal_PrincipalID]);
GO

-- Creating foreign key on [GF_SkillLevel_Id] in table 'GF_AssignedSkill'
ALTER TABLE [dbo].[GF_AssignedSkill]
ADD CONSTRAINT [FK_GF_SkillLevelGF_AssignedSkill]
    FOREIGN KEY ([GF_SkillLevel_Id])
    REFERENCES [dbo].[GF_SkillLevel]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GF_SkillLevelGF_AssignedSkill'
CREATE INDEX [IX_FK_GF_SkillLevelGF_AssignedSkill]
ON [dbo].[GF_AssignedSkill]
    ([GF_SkillLevel_Id]);
GO

-- Creating foreign key on [GF_Quiz_Id] in table 'GF_Field'
ALTER TABLE [dbo].[GF_Field]
ADD CONSTRAINT [FK_GF_QuizGF_Field]
    FOREIGN KEY ([GF_Quiz_Id])
    REFERENCES [dbo].[GF_Quiz]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GF_QuizGF_Field'
CREATE INDEX [IX_FK_GF_QuizGF_Field]
ON [dbo].[GF_Field]
    ([GF_Quiz_Id]);
GO

-- Creating foreign key on [GF_Field_Id] in table 'GF_Option'
ALTER TABLE [dbo].[GF_Option]
ADD CONSTRAINT [FK_GF_FieldGF_Option]
    FOREIGN KEY ([GF_Field_Id])
    REFERENCES [dbo].[GF_Field]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GF_FieldGF_Option'
CREATE INDEX [IX_FK_GF_FieldGF_Option]
ON [dbo].[GF_Option]
    ([GF_Field_Id]);
GO

-- Creating foreign key on [GF_Response_Id] in table 'GF_ResponseField'
ALTER TABLE [dbo].[GF_ResponseField]
ADD CONSTRAINT [FK_GF_ResponseGF_ResponseField]
    FOREIGN KEY ([GF_Response_Id])
    REFERENCES [dbo].[GF_Response]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GF_ResponseGF_ResponseField'
CREATE INDEX [IX_FK_GF_ResponseGF_ResponseField]
ON [dbo].[GF_ResponseField]
    ([GF_Response_Id]);
GO

-- Creating foreign key on [Principal_PrincipalID] in table 'GF_Response'
ALTER TABLE [dbo].[GF_Response]
ADD CONSTRAINT [FK_PrincipalGF_Response]
    FOREIGN KEY ([Principal_PrincipalID])
    REFERENCES [dbo].[Principal]
        ([PrincipalID])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_PrincipalGF_Response'
CREATE INDEX [IX_FK_PrincipalGF_Response]
ON [dbo].[GF_Response]
    ([Principal_PrincipalID]);
GO

-- Creating foreign key on [GF_Field_Id] in table 'GF_Response'
ALTER TABLE [dbo].[GF_Response]
ADD CONSTRAINT [FK_GF_FieldGF_Response]
    FOREIGN KEY ([GF_Field_Id])
    REFERENCES [dbo].[GF_Field]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GF_FieldGF_Response'
CREATE INDEX [IX_FK_GF_FieldGF_Response]
ON [dbo].[GF_Response]
    ([GF_Field_Id]);
GO

-- Creating foreign key on [GF_Tournament_Id] in table 'GF_TournamentAdmin'
ALTER TABLE [dbo].[GF_TournamentAdmin]
ADD CONSTRAINT [FK_GF_TournamentGF_TournamentAdmin]
    FOREIGN KEY ([GF_Tournament_Id])
    REFERENCES [dbo].[GF_Tournament]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GF_TournamentGF_TournamentAdmin'
CREATE INDEX [IX_FK_GF_TournamentGF_TournamentAdmin]
ON [dbo].[GF_TournamentAdmin]
    ([GF_Tournament_Id]);
GO

-- Creating foreign key on [GF_Tournament_Id] in table 'GF_TournamentMember'
ALTER TABLE [dbo].[GF_TournamentMember]
ADD CONSTRAINT [FK_GF_TournamentGF_TournamentMember]
    FOREIGN KEY ([GF_Tournament_Id])
    REFERENCES [dbo].[GF_Tournament]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GF_TournamentGF_TournamentMember'
CREATE INDEX [IX_FK_GF_TournamentGF_TournamentMember]
ON [dbo].[GF_TournamentMember]
    ([GF_Tournament_Id]);
GO

-- Creating foreign key on [GF_Tournament_Id] in table 'GF_SpecialBet'
ALTER TABLE [dbo].[GF_SpecialBet]
ADD CONSTRAINT [FK_GF_TournamentGF_SpecialBet]
    FOREIGN KEY ([GF_Tournament_Id])
    REFERENCES [dbo].[GF_Tournament]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GF_TournamentGF_SpecialBet'
CREATE INDEX [IX_FK_GF_TournamentGF_SpecialBet]
ON [dbo].[GF_SpecialBet]
    ([GF_Tournament_Id]);
GO

-- Creating foreign key on [GF_SpecialBet_Id] in table 'GF_SpecialbetOption'
ALTER TABLE [dbo].[GF_SpecialbetOption]
ADD CONSTRAINT [FK_GF_SpecialBetGF_SpecialbetOption]
    FOREIGN KEY ([GF_SpecialBet_Id])
    REFERENCES [dbo].[GF_SpecialBet]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GF_SpecialBetGF_SpecialbetOption'
CREATE INDEX [IX_FK_GF_SpecialBetGF_SpecialbetOption]
ON [dbo].[GF_SpecialbetOption]
    ([GF_SpecialBet_Id]);
GO

-- Creating foreign key on [GF_Tournament_Id] in table 'GF_Game'
ALTER TABLE [dbo].[GF_Game]
ADD CONSTRAINT [FK_GF_TournamentGF_Game]
    FOREIGN KEY ([GF_Tournament_Id])
    REFERENCES [dbo].[GF_Tournament]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GF_TournamentGF_Game'
CREATE INDEX [IX_FK_GF_TournamentGF_Game]
ON [dbo].[GF_Game]
    ([GF_Tournament_Id]);
GO

-- Creating foreign key on [GF_ExternalTournament_Id] in table 'GF_ExternalTeam'
ALTER TABLE [dbo].[GF_ExternalTeam]
ADD CONSTRAINT [FK_GF_ExternalTournamentGF_ExternalTeam]
    FOREIGN KEY ([GF_ExternalTournament_Id])
    REFERENCES [dbo].[GF_Tournament_GF_ExternalTournament]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GF_ExternalTournamentGF_ExternalTeam'
CREATE INDEX [IX_FK_GF_ExternalTournamentGF_ExternalTeam]
ON [dbo].[GF_ExternalTeam]
    ([GF_ExternalTournament_Id]);
GO

-- Creating foreign key on [GF_Tournament_Id] in table 'GF_Placedbet'
ALTER TABLE [dbo].[GF_Placedbet]
ADD CONSTRAINT [FK_GF_TournamentGF_Placedbet]
    FOREIGN KEY ([GF_Tournament_Id])
    REFERENCES [dbo].[GF_Tournament]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GF_TournamentGF_Placedbet'
CREATE INDEX [IX_FK_GF_TournamentGF_Placedbet]
ON [dbo].[GF_Placedbet]
    ([GF_Tournament_Id]);
GO

-- Creating foreign key on [GF_Placedbet_Id] in table 'GF_PlacedGameBet'
ALTER TABLE [dbo].[GF_PlacedGameBet]
ADD CONSTRAINT [FK_GF_PlacedbetGF_PlacedGameBet]
    FOREIGN KEY ([GF_Placedbet_Id])
    REFERENCES [dbo].[GF_Placedbet]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GF_PlacedbetGF_PlacedGameBet'
CREATE INDEX [IX_FK_GF_PlacedbetGF_PlacedGameBet]
ON [dbo].[GF_PlacedGameBet]
    ([GF_Placedbet_Id]);
GO

-- Creating foreign key on [GF_Placedbet_Id] in table 'GF_PlacedSpecialbet'
ALTER TABLE [dbo].[GF_PlacedSpecialbet]
ADD CONSTRAINT [FK_GF_PlacedbetGF_PlacedSpecialbet]
    FOREIGN KEY ([GF_Placedbet_Id])
    REFERENCES [dbo].[GF_Placedbet]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GF_PlacedbetGF_PlacedSpecialbet'
CREATE INDEX [IX_FK_GF_PlacedbetGF_PlacedSpecialbet]
ON [dbo].[GF_PlacedSpecialbet]
    ([GF_Placedbet_Id]);
GO

-- Creating foreign key on [GF_Tournament_Id] in table 'GF_TournamentUser'
ALTER TABLE [dbo].[GF_TournamentUser]
ADD CONSTRAINT [FK_GF_TournamentGF_TournamentUser]
    FOREIGN KEY ([GF_Tournament_Id])
    REFERENCES [dbo].[GF_Tournament]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GF_TournamentGF_TournamentUser'
CREATE INDEX [IX_FK_GF_TournamentGF_TournamentUser]
ON [dbo].[GF_TournamentUser]
    ([GF_Tournament_Id]);
GO

-- Creating foreign key on [GF_InternalTournament_Id] in table 'GF_InteralTeam'
ALTER TABLE [dbo].[GF_InteralTeam]
ADD CONSTRAINT [FK_GF_InternalTournamentGF_InteralTeam]
    FOREIGN KEY ([GF_InternalTournament_Id])
    REFERENCES [dbo].[GF_Tournament_GF_InternalTournament]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GF_InternalTournamentGF_InteralTeam'
CREATE INDEX [IX_FK_GF_InternalTournamentGF_InteralTeam]
ON [dbo].[GF_InteralTeam]
    ([GF_InternalTournament_Id]);
GO

-- Creating foreign key on [GF_Quiz_Id] in table 'GF_QuizAdmin'
ALTER TABLE [dbo].[GF_QuizAdmin]
ADD CONSTRAINT [FK_GF_QuizGF_QuizAdmin]
    FOREIGN KEY ([GF_Quiz_Id])
    REFERENCES [dbo].[GF_Quiz]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GF_QuizGF_QuizAdmin'
CREATE INDEX [IX_FK_GF_QuizGF_QuizAdmin]
ON [dbo].[GF_QuizAdmin]
    ([GF_Quiz_Id]);
GO

-- Creating foreign key on [GF_Quiz_Id] in table 'GF_QuizMembers'
ALTER TABLE [dbo].[GF_QuizMembers]
ADD CONSTRAINT [FK_GF_QuizGF_QuizMembers]
    FOREIGN KEY ([GF_Quiz_Id])
    REFERENCES [dbo].[GF_Quiz]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GF_QuizGF_QuizMembers'
CREATE INDEX [IX_FK_GF_QuizGF_QuizMembers]
ON [dbo].[GF_QuizMembers]
    ([GF_Quiz_Id]);
GO

-- Creating foreign key on [GF_Quiz_Id] in table 'GF_QuizAction'
ALTER TABLE [dbo].[GF_QuizAction]
ADD CONSTRAINT [FK_GF_QuizGF_QuizAction]
    FOREIGN KEY ([GF_Quiz_Id])
    REFERENCES [dbo].[GF_Quiz]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GF_QuizGF_QuizAction'
CREATE INDEX [IX_FK_GF_QuizGF_QuizAction]
ON [dbo].[GF_QuizAction]
    ([GF_Quiz_Id]);
GO

-- Creating foreign key on [GF_Achievement_Id] in table 'GF_QuizAction'
ALTER TABLE [dbo].[GF_QuizAction]
ADD CONSTRAINT [FK_GF_AchievementGF_QuizAction]
    FOREIGN KEY ([GF_Achievement_Id])
    REFERENCES [dbo].[GF_Achievement]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GF_AchievementGF_QuizAction'
CREATE INDEX [IX_FK_GF_AchievementGF_QuizAction]
ON [dbo].[GF_QuizAction]
    ([GF_Achievement_Id]);
GO

-- Creating foreign key on [GF_Tournament_Id] in table 'GF_TournamentAction'
ALTER TABLE [dbo].[GF_TournamentAction]
ADD CONSTRAINT [FK_GF_TournamentGF_TournamentAction]
    FOREIGN KEY ([GF_Tournament_Id])
    REFERENCES [dbo].[GF_Tournament]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GF_TournamentGF_TournamentAction'
CREATE INDEX [IX_FK_GF_TournamentGF_TournamentAction]
ON [dbo].[GF_TournamentAction]
    ([GF_Tournament_Id]);
GO

-- Creating foreign key on [GF_Achievement_Id] in table 'GF_TournamentAction'
ALTER TABLE [dbo].[GF_TournamentAction]
ADD CONSTRAINT [FK_GF_AchievementGF_TournamentAction]
    FOREIGN KEY ([GF_Achievement_Id])
    REFERENCES [dbo].[GF_Achievement]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GF_AchievementGF_TournamentAction'
CREATE INDEX [IX_FK_GF_AchievementGF_TournamentAction]
ON [dbo].[GF_TournamentAction]
    ([GF_Achievement_Id]);
GO

-- Creating foreign key on [NB_Channel_ChannelID] in table 'GF_TournamentUser'
ALTER TABLE [dbo].[GF_TournamentUser]
ADD CONSTRAINT [FK_NB_ChannelGF_TournamentUser]
    FOREIGN KEY ([NB_Channel_ChannelID])
    REFERENCES [dbo].[NB_Channel]
        ([ChannelID])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_NB_ChannelGF_TournamentUser'
CREATE INDEX [IX_FK_NB_ChannelGF_TournamentUser]
ON [dbo].[GF_TournamentUser]
    ([NB_Channel_ChannelID]);
GO

-- Creating foreign key on [Id] in table 'GF_Achievement_GF_Skills'
ALTER TABLE [dbo].[GF_Achievement_GF_Skills]
ADD CONSTRAINT [FK_GF_Skills_inherits_GF_Achievement]
    FOREIGN KEY ([Id])
    REFERENCES [dbo].[GF_Achievement]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

-- Creating foreign key on [Id] in table 'GF_Achievement_GF_Badge'
ALTER TABLE [dbo].[GF_Achievement_GF_Badge]
ADD CONSTRAINT [FK_GF_Badge_inherits_GF_Achievement]
    FOREIGN KEY ([Id])
    REFERENCES [dbo].[GF_Achievement]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

-- Creating foreign key on [Id] in table 'GF_Achievement_GF_Certificate'
ALTER TABLE [dbo].[GF_Achievement_GF_Certificate]
ADD CONSTRAINT [FK_GF_Certificate_inherits_GF_Achievement]
    FOREIGN KEY ([Id])
    REFERENCES [dbo].[GF_Achievement]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

-- Creating foreign key on [Id] in table 'GF_Tournament_GF_ExternalTournament'
ALTER TABLE [dbo].[GF_Tournament_GF_ExternalTournament]
ADD CONSTRAINT [FK_GF_ExternalTournament_inherits_GF_Tournament]
    FOREIGN KEY ([Id])
    REFERENCES [dbo].[GF_Tournament]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

-- Creating foreign key on [Id] in table 'GF_Tournament_GF_InternalTournament'
ALTER TABLE [dbo].[GF_Tournament_GF_InternalTournament]
ADD CONSTRAINT [FK_GF_InternalTournament_inherits_GF_Tournament]
    FOREIGN KEY ([Id])
    REFERENCES [dbo].[GF_Tournament]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO
